
//
// Vertex shader for particles effect
//
// Author: Shirley Carter
//
attribute vec4 inPosition;
attribute vec4 inColor;
attribute vec3 velocity;
attribute float startTime;

uniform mat4 mvpMat;

uniform float time;
uniform vec4 background;

varying vec4 color;

void main()
{
    vec4 vert;
    float t = time-startTime;
   
    vert = inPosition + vec4(velocity*t,0.0);
    if ( t >=0.0) {
         vert.x += 4.9*t*t;
         vert.y -= 4.9*t*t;
        color = inColor;
        color.a = 0.5;
    }
    else {
        vert = inPosition;
        color = background;
    }
	gl_Position = mvpMat * vert;
   // gl_PointSize = -8.0*t*t+8.0*t+0.1*vert.y +6.0;
    gl_TexCoord[0] = gl_MultiTexCoord0;
} 
